* =============================================
* read in.sas
*
* This code creates an analytic file from the
* March 2013 supplement to the CPS.
*
* Source: Cathi Callahan
*         Actuarial Research Corporation
  ;

%let path=C:\Users\Dan WALDO\Documents\DOL\Mar2013;

* Insert the appropriate path and
  folder names in the next three lines.
  ;
libname mar13 "&path.\sas"; * Location for SAS data file;
libname library "&path.\sas"; * Location for formats;
filename ARC "&path.\newout6pff.13"; * location of input ASCII file;

proc format library=library;
  value yesnof
    0 ='0 no'
    1 ='1 yes';
  value offerf
    0 ='0 n/a'
    1 ='1 coverage through current employer'
    2 ='2 offered, eligible, not enrolled'
    3 ='3 offered, not enrolled, not eligible'
    4 ='4 not offered';
  value priorf
    0 ='0 n/a'
    1 ='1 yes'
    2 ='2 no, current employer';
  value newsectorf
    0 ='0 n/a'
    1 ='1 Private'
    2 ='2 Public, Federal'
    3 ='3 Public, State'
    4 ='4 Public, Local'
    5 ='5 Self-Employed, inc'
    6 ='6 Self-Employed, uninc';
  value newsizef
    0 ='0 n/a'
    1 ='1 less than 10'
    2 ='2 10 - 49'
    3 ='3 50 - 99'
    4 ='4 100 - 499'
    5 ='5 500 - 999'
    6 ='6 1000 or more';
  value eepriorf
    0 ='0 n/a'
    1 ='1 yes, prior'
    2 ='2 no, current employer';
  value siflagf
    0 ='0 n/a'
    1 ='1 self-insured'
    2 ='2 fully-insured';
  value hmoflagf
    0 ='0 n/a'
    1 ='1 HMO'
    2 ='2 PPO'
    3 ='3 POS'
    4 ='4 HDED';
  value retflagf
    0 ='0 n/a'
    1 ='1 retiree' 
    2 ='2 COBRA';
  value unionf
    0 ='0 n/a'
    1 ='1 yes, union'
    2 ='2 no, not union';
  value mspflagf
    0 ='0 Person does not have Medicare'
    1 ='1 Medicare is secondary (ESI Primary)'
    2 ='2 Medicare is primary (may or may not have ESI)';
  ;
  run;

data mar13.mar13;
  infile ARC lrecl=105 missover termstr=crlf;
  attrib
    PHSEQ length=4 label='Household Sequence Number'
    HNUMPER length=3 label='Number of Persons in Household'
    ALINENO length=3 label='Person Line Number'
    ESIPH length=3 label='ESI policy holder?'
    ESIDEP length=3 label='ESI dependent?'
    OPHIPH length=3 label='Other private health insurance policy holder?'
    OPHIDEP length=3 label='Other private health insurance dependent?'
    NMCAID length=3 label='Covered by Medicaid?'
    NMCARE length=3 label='Covered by Medicare?'
    CHAMP length=3 label='Covered by Military?'
    OTHER length=3 label='Covered by Other?'
    CHIPP length=3 label='Covered by Childrens Health Insurance?'
    MARSUPWT length=8 label='March Supplement Weight (float, 2 decimal places)' format=8.2
    OFFER length=3 label='Does your employer offer Health Insurance?'
    PRIOR length=3 label='Do you have ESI through a Prior Employer?'
    NEWSECTOR length=3 label='What sector is providing coverage?'
    NEWSIZE length=3 label='What size employer provided the coverage?'
    EEPRIOR length=3 label='Coverage through a prior employer (dependents only, attribute of policyholder)'
    PHLINE length=3 label='Line number (ALINENO) of First Policy holder (deps. who are not ESI policy holders only)'
    SIFLAG length=3 label='Was coverage fully-insured or self-insured?'
    HMOFLAG length=3 label='What type of plan are you covered by?'
    RETFLAG length=3 label='Is prior coverage retiree or COBRA? (universe is PRIOR=1 or EEPRIOR=1)'
    PH2LINE length=3 label='Line number (ALINENO) of second policy holder'
    NEWSECTOR2 length=3 label='Sector of coverage through second policy holder (if PH2LINE > 0).'
    NEWSIZE2 length=3 label='Size of employer covering through second policy holder (if PH2LINE > 0)'
    UNION length=3 label='Coverage through union? (for ESI Policy holders only, non-self-employed)'
    EEUNION length=3 label='Coverage through a union? (for ESI deps only, based on PH attribute)'
    UNIONWORK length=3 label='Union? (for non-self-employed workers only, current employment status)'
    AV length=8 label='Actuarial Value (active ESI policy holder records only)'
    AVCELLAVG length=8 label='Cell based average actuarial value (active ESI policy holder records only)'
    AV_EXPER length=8 label='Experimental Actuarial Value (active ESI policy holder records only)'
    MSPFLAG length=3 label='Medicare Secondary Payer variable (all Medicare)'
    OOPEXP length=8 label='Out of Pocket Expenditures on Over the Counter Purchases and Medical Equipment (sum of POTC-VAL and PMED-VAL)' format=dollar12.
    ;
  input
  @001  PHSEQ
  @007  HNUMPER
  @010  ALINENO
  @013  ESIPH
  @015  ESIDEP
  @017  OPHIPH
  @019  OPHIDEP
  @021  NMCAID
  @023  NMCARE
  @025  CHAMP
  @027  OTHER
  @029  CHIPP
  @031  MARSUPWT 8.2
  @040  OFFER
  @042  PRIOR
  @044  NEWSECTOR
  @046  NEWSIZE
  @048  EEPRIOR
  @050  PHLINE
  @053  SIFLAG
  @055  HMOFLAG
  @057  RETFLAG
  @059  PH2LINE
  @061  NEWSECTOR2
  @063  NEWSIZE2
  @065  UNION
  @067  EEUNION
  @069  UNIONWORK
  @071  AV
  @079  AVCELLAVG
  @087  AV_EXPER
  @095  MSPFLAG
  @097  OOPEXP
  ;
* Comment out the following format statement unless you wish
  the data to appear as formatted values in susbsequent output;
  format
  ESIPH  yesnof.
  ESIDEP  yesnof.
  OPHIPH  yesnof.
  OPHIDEP  yesnof.
  NMCAID  yesnof.
  NMCARE   yesnof.
  CHAMP  yesnof.
  OTHER  yesnof.
  CHIPP  yesnof.
  OFFER  offerf.
  PRIOR  priorf.
  NEWSECTOR  newsectorf.
  NEWSIZE  newsizef.
  EEPRIOR  eepriorf.
  SIFLAG  siflagf.
  HMOFLAG  hmoflagf.
  RETFLAG  retflagf.
  NEWSECTOR2  newsectorf.
  NEWSIZE2  newsizef.
  UNION  unionf.
  EEUNION  unionf.
  UNIONWORK  unionf.
  MSPFLAG  mspflagf.
  ;
  run;

proc contents data=mar13.mar13;
  run;

proc freq data=mar13.mar13;
  table
  HNUMPER ALINENO ESIPH 
  ESIDEP OPHIPH OPHIDEP NMCAID 
  NMCARE CHAMP OTHER CHIPP
  OFFER PRIOR NEWSECTOR NEWSIZE 
  EEPRIOR PHLINE SIFLAG HMOFLAG
  RETFLAG PH2LINE NEWSECTOR2 NEWSIZE2 
  UNION EEUNION UNIONWORK MSPFLAG
  ;
  run;

proc univariate data=mar13.mar13;
  var
  PHSEQ MARSUPWT AV
  AVCELLAVG AV_EXPER OOPEXP
  ;
  run;
